/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis.params;

import net.impactdev.impactor.relocations.redis.clients.jedis.CommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.Protocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.args.SortingOrder;
import net.impactdev.impactor.relocations.redis.clients.jedis.params.IParams;

public class GeoRadiusParam
implements IParams {
    private boolean withCoord = false;
    private boolean withDist = false;
    private boolean withHash = false;
    private Integer count = null;
    private boolean any = false;
    private SortingOrder sortingOrder = null;

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.withCoord = true;
        return this;
    }

    public GeoRadiusParam withDist() {
        this.withDist = true;
        return this;
    }

    public GeoRadiusParam withHash() {
        this.withHash = true;
        return this;
    }

    public GeoRadiusParam sortAscending() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public GeoRadiusParam sortDescending() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public GeoRadiusParam sortingOrder(SortingOrder order) {
        this.sortingOrder = order;
        return this;
    }

    public GeoRadiusParam count(int count) {
        this.count = count;
        return this;
    }

    public GeoRadiusParam count(int count, boolean any) {
        this.count = count;
        this.any = any;
        return this;
    }

    public GeoRadiusParam any() {
        if (this.count == null) {
            throw new IllegalArgumentException("COUNT must be set before ANY to be set");
        }
        this.any = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.withCoord) {
            args2.add(Protocol.Keyword.WITHCOORD);
        }
        if (this.withDist) {
            args2.add(Protocol.Keyword.WITHDIST);
        }
        if (this.withHash) {
            args2.add(Protocol.Keyword.WITHHASH);
        }
        if (this.count != null) {
            args2.add(Protocol.Keyword.COUNT).add(this.count);
            if (this.any) {
                args2.add(Protocol.Keyword.ANY);
            }
        }
        if (this.sortingOrder != null) {
            args2.add(this.sortingOrder);
        }
    }
}

